import os
import json
import datetime
import webbrowser
import random
import time
from time import sleep

# Константы
VERSION = "1.1.0 beta-Home"
LICENSE_FILE = "license.json"
SETTINGS_FILE = "settings.json"
NOTES_DIR = "notes"
USERS_FILE = "users.json"
LOG_FILE = "system.log"
LICENSE_KEYS = {
    "RB-TEMP-7DAY-ABCD": {"type": "trial", "days": 7, "name": "7-дневная пробная"},
    "RB-TEMP-30DAY-EFGH": {"type": "trial", "days": 30, "name": "30-дневная пробная"},
    "RB-PERM-UNLIM-IJKL": {"type": "permanent", "name": "Бессрочная лицензия"}
}

STARTUP_ANIMATION = """
██████╗ ██╗   ██╗██████╗ ██╗███╗   ██╗
██╔══██╗██║   ██║██╔══██╗██║████╗  ██║
██████╔╝██║   ██║██████╔╝██║██╔██╗ ██║
██╔══██╗██║   ██║██╔══██╗██║██║╚██╗██║
██║  ██║╚██████╔╝██████╔╝██║██║ ╚████║
╚═╝  ╚═╝ ╚═════╝ ╚═════╝ ╚═╝╚═╝  ╚═══╝
OS 1.1 beta Загрузка...
"""

class RubinOS:
    def __init__(self):
        self.current_user = None
        self.license_valid = False
        self.license_type = None
        self.license_name = None
        self.license_expiry = None
        self.settings = {}
        self.users = {}
        self.current_screen = "desktop"
        self.running = True
        self.last_activity = datetime.datetime.now()
        
        # Создаем необходимые файлы и папки
        if not os.path.exists(NOTES_DIR):
            os.makedirs(NOTES_DIR)
            
        # Инициализация файлов
        self.init_files()
        
        # Загрузка данных
        self.load_data()
        
        # Логирование запуска системы
        self.log("SYSTEM", "Система запущена")
    
    def init_files(self):
        """Инициализация всех необходимых файлов"""
        default_license = {
            "active_license": False,
            "license_key": "",
            "activation_date": None,
            "expiry_date": None
        }
        
        default_settings = {
            "pc_name": "Ru.bin-PC",
            "workgroup": "HOME",
            "theme": "default",
            "autoclear": True,
            "log_actions": True
        }
        
        default_users = {
            "users": [
                {
                    "username": "Admin",
                    "password": "1234",
                    "role": "admin"
                }
            ],
            "current_user": None
        }
        
        # Создаем файлы если они не существуют
        if not os.path.exists(LICENSE_FILE):
            with open(LICENSE_FILE, 'w') as f:
                json.dump(default_license, f, indent=4)
        
        if not os.path.exists(SETTINGS_FILE):
            with open(SETTINGS_FILE, 'w') as f:
                json.dump(default_settings, f, indent=4)
        
        if not os.path.exists(USERS_FILE):
            with open(USERS_FILE, 'w') as f:
                json.dump(default_users, f, indent=4)
        
        # Инициализация лог-файла
        if not os.path.exists(LOG_FILE):
            with open(LOG_FILE, 'w') as f:
                f.write(f"Ru.bin OS Log File\nCreated: {datetime.datetime.now()}\n\n")
    
    def load_data(self):
        """Загрузка всех данных из файлов"""
        with open(LICENSE_FILE, 'r') as f:
            self.license_data = json.load(f)
        
        with open(SETTINGS_FILE, 'r') as f:
            self.settings = json.load(f)
        
        with open(USERS_FILE, 'r') as f:
            self.users_data = json.load(f)
    
    def save_data(self, data_type):
        """Сохранение данных в файлы"""
        if data_type == "settings":
            with open(SETTINGS_FILE, 'w') as f:
                json.dump(self.settings, f, indent=4)
        elif data_type == "users":
            with open(USERS_FILE, 'w') as f:
                json.dump(self.users_data, f, indent=4)
        elif data_type == "license":
            with open(LICENSE_FILE, 'w') as f:
                json.dump(self.license_data, f, indent=4)
    
    def log(self, category, message):
        """Логирование действий"""
        timestamp = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        log_entry = f"[{timestamp}] [{category}] {message}\n"
        
        with open(LOG_FILE, 'a') as f:
            f.write(log_entry)
    
    def clear_screen(self):
        """Очистка экрана с учетом настроек"""
        if self.settings.get('autoclear', True):
            os.system('cls' if os.name == 'nt' else 'clear')
    
    def check_license(self):
        """Проверка лицензии"""
        if not self.license_data["active_license"] or not self.license_data["license_key"]:
            self.license_valid = False
            return False
            
        license_key = self.license_data["license_key"]
        
        # Проверка известных лицензий
        if license_key in LICENSE_KEYS:
            license_info = LICENSE_KEYS[license_key]
            self.license_type = license_info["type"]
            self.license_name = license_info["name"]
            
            if license_info["type"] == "trial":
                activation_date = datetime.datetime.strptime(self.license_data["activation_date"], "%Y-%m-%d")
                expiry_date = activation_date + datetime.timedelta(days=license_info["days"])
                self.license_expiry = expiry_date.strftime("%Y-%m-%d")
                
                if datetime.datetime.now() > expiry_date:
                    self.license_valid = False
                    self.log("LICENSE", f"Лицензия истекла: {license_key}")
                    return False
            
            self.license_valid = True
            return True
        
        self.license_valid = False
        return False
    
    def activate_license_screen(self):
        """Экран активации лицензии"""
        self.clear_screen()
        print("\n--- Активация Ru.bin OS ---")
        print("Для использования системы необходимо активировать лицензию.")
        print("Пожалуйста, приобретите лицензию на сайте Ru.bin")
        print("http://z9081972.beget.tech/")
        print("\nПосле покупки вы получите лицензионный ключ.")
        
        while True:
            license_key = input("\nВведите лицензионный ключ (или 'выход' для выхода): ").strip().upper()
            
            if license_key.lower() == 'выход':
                self.running = False
                return
                
            if license_key in LICENSE_KEYS:
                self.license_data["active_license"] = True
                self.license_data["license_key"] = license_key
                self.license_data["activation_date"] = datetime.datetime.now().strftime("%Y-%m-%d")
                
                if LICENSE_KEYS[license_key]["type"] == "trial":
                    expiry_date = datetime.datetime.now() + datetime.timedelta(days=LICENSE_KEYS[license_key]["days"])
                    self.license_data["expiry_date"] = expiry_date.strftime("%Y-%m-%d")
                
                self.save_data("license")
                self.log("LICENSE", f"Активирована лицензия: {license_key}")
                print(f"\nЛицензия успешно активирована! ({LICENSE_KEYS[license_key]['name']})")
                sleep(2)
                return
            else:
                print("Неверный лицензионный ключ. Попробуйте еще раз.")
                print("Пример ключа: RB-XXXX-XXXX-XXXX")
    
    def show_startup_animation(self):
        """Показ анимации при запуске"""
        self.clear_screen()
        for line in STARTUP_ANIMATION.split('\n'):
            print(line)
            sleep(0.2)
    
    def show_status_bar(self):
        """Отображение статус-бара с временем и датой"""
        now = datetime.datetime.now()
        status_line = f"[Пользователь: {self.current_user}] [Лицензия: {self.license_name if self.license_valid else 'Нет'}]"
        status_line += f" [Дата: {now.strftime('%d.%m.%Y')}] [Время: {now.strftime('%H:%M:%S')}]"
        print("\n" + "=" * os.get_terminal_size().columns)
        print(status_line)
        print("=" * os.get_terminal_size().columns)
    
    def login(self):
        """Экран входа в систему"""
        self.clear_screen()
        print("\n--- Вход в Ru.bin OS ---")
        
        # Показываем список пользователей
        print("\nДоступные пользователи:")
        for i, user in enumerate(self.users_data["users"], 1):
            print(f"{i}. {user['username']} ({user['role']})")
        
        while True:
            try:
                choice = input("\nВыберите пользователя (номер) или '0' для выхода: ")
                
                if choice == "0":
                    return False
                
                user_idx = int(choice) - 1
                if 0 <= user_idx < len(self.users_data["users"]):
                    selected_user = self.users_data["users"][user_idx]
                    password = input(f"Пароль для {selected_user['username']}: ")
                    
                    if password == selected_user["password"]:
                        self.current_user = selected_user["username"]
                        self.users_data["current_user"] = selected_user["username"]
                        self.save_data("users")
                        self.log("AUTH", f"Успешный вход пользователя: {self.current_user}")
                        return True
                    else:
                        print("Неверный пароль. Попробуйте еще раз.")
                        self.log("AUTH", f"Неудачная попытка входа пользователя: {selected_user['username']}")
                else:
                    print("Неверный выбор. Попробуйте еще раз.")
            except ValueError:
                print("Пожалуйста, введите номер пользователя.")
    
    def desktop(self):
        """Рабочий стол"""
        while True:
            self.clear_screen()
            print("\n--- Рабочий стол ---")
            print(f"Добро пожаловать, {self.current_user}!")
            print(f"Система: Ru.bin OS {VERSION}")
            
            self.show_status_bar()
            
            print("\nДоступные приложения:")
            print("1. Меню Пуск")
            print("2. Блокнот")
            print("3. Браузер")
            print("4. Настройки")
            print("5. Командная строка")
            print("6. Игры")
            print("7. Калькулятор")
            print("0. Выход из системы")
            
            try:
                choice = input("\nВыберите приложение (номер): ")
                
                if choice == "1":
                    self.start_menu()
                elif choice == "2":
                    self.notepad()
                elif choice == "3":
                    self.browser()
                elif choice == "4":
                    self.settings_menu()
                elif choice == "5":
                    self.command_line()
                elif choice == "6":
                    self.games_menu()
                elif choice == "7":
                    self.calculator()
                elif choice == "0":
                    self.current_user = None
                    self.users_data["current_user"] = None
                    self.save_data("users")
                    self.log("SYSTEM", "Выход из системы")
                    self.running = False
                    return
                else:
                    print("Неверный выбор. Попробуйте еще раз.")
                    sleep(1)
            except KeyboardInterrupt:
                print("\nИспользуйте меню для выхода из системы.")
                sleep(1)
    
    def start_menu(self):
        """Меню Пуск"""
        self.clear_screen()
        print("\n--- Меню Пуск ---")
        print("1. Календарь")
        print("2. Блокнот")
        print("3. Браузер")
        print("4. Настройки")
        print("5. Командная строка")
        print("6. Игры")
        print("7. Калькулятор")
        print("8. Сведения о системе")
        print("0. Назад")
        
        choice = input("\nВыберите пункт меню: ")
        
        if choice == "1":
            self.calendar()
        elif choice == "2":
            self.notepad()
        elif choice == "3":
            self.browser()
        elif choice == "4":
            self.settings_menu()
        elif choice == "5":
            self.command_line()
        elif choice == "6":
            self.games_menu()
        elif choice == "7":
            self.calculator()
        elif choice == "8":
            self.system_info()
        elif choice == "0":
            return
    
    def calendar(self):
        """Календарь"""
        self.clear_screen()
        print("\n--- Календарь ---")
        today = datetime.date.today()
        print(f"Сегодня: {today.strftime('%d.%m.%Y')}")
        print(f"День недели: {['Понедельник', 'Вторник', 'Среда', 'Четверг', 'Пятница', 'Суббота', 'Воскресенье'][today.weekday()]}")
        
        self.log("APP", "Просмотр календаря")
        input("\nНажмите Enter для возврата...")
    
    def notepad(self):
        """Блокнот"""
        while True:
            self.clear_screen()
            print("\n--- Блокнот ---")
            print("1. Создать новую заметку")
            print("2. Просмотреть заметки")
            print("3. Редактировать заметку")
            print("4. Удалить заметку")
            print("0. Назад")
            
            choice = input("\nВыберите действие: ")
            
            if choice == "1":
                note_name = input("\nВведите название заметки: ")
                note_content = input("Введите текст заметки: ")
                
                note_file = os.path.join(NOTES_DIR, f"{note_name}.txt")
                with open(note_file, 'w', encoding='utf-8') as f:
                    f.write(note_content)
                
                self.log("NOTEPAD", f"Создана заметка: {note_name}")
                print("\nЗаметка сохранена!")
                sleep(1)
            
            elif choice == "2":
                notes = [f for f in os.listdir(NOTES_DIR) if f.endswith('.txt')]
                if not notes:
                    print("\nНет сохраненных заметок.")
                else:
                    print("\nСписок заметок:")
                    for i, note in enumerate(notes, 1):
                        print(f"{i}. {note[:-4]}")
                    
                    note_choice = input("\nВведите номер заметки для просмотра (или 0 для отмены): ")
                    if note_choice != "0":
                        try:
                            note_idx = int(note_choice) - 1
                            if 0 <= note_idx < len(notes):
                                with open(os.path.join(NOTES_DIR, notes[note_idx]), 'r', encoding='utf-8') as f:
                                    print(f"\nСодержимое заметки '{notes[note_idx][:-4]}':")
                                    print(f.read())
                                
                                self.log("NOTEPAD", f"Просмотр заметки: {notes[note_idx]}")
                            else:
                                print("\nНеверный номер заметки.")
                        except ValueError:
                            print("\nНеверный ввод.")
                
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "3":
                notes = [f for f in os.listdir(NOTES_DIR) if f.endswith('.txt')]
                if not notes:
                    print("\nНет сохраненных заметок.")
                else:
                    print("\nСписок заметок:")
                    for i, note in enumerate(notes, 1):
                        print(f"{i}. {note[:-4]}")
                    
                    note_choice = input("\nВведите номер заметки для редактирования (или 0 для отмены): ")
                    if note_choice != "0":
                        try:
                            note_idx = int(note_choice) - 1
                            if 0 <= note_idx < len(notes):
                                with open(os.path.join(NOTES_DIR, notes[note_idx]), 'r', encoding='utf-8') as f:
                                    content = f.read()
                                
                                print(f"\nТекущее содержимое заметки '{notes[note_idx][:-4]}':")
                                print(content)
                                new_content = input("\nВведите новый текст заметки: ")
                                
                                with open(os.path.join(NOTES_DIR, notes[note_idx]), 'w', encoding='utf-8') as f:
                                    f.write(new_content)
                                
                                self.log("NOTEPAD", f"Изменена заметка: {notes[note_idx]}")
                                print("\nЗаметка обновлена!")
                                sleep(1)
                            else:
                                print("\nНеверный номер заметки.")
                        except ValueError:
                            print("\nНеверный ввод.")
                
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "4":
                notes = [f for f in os.listdir(NOTES_DIR) if f.endswith('.txt')]
                if not notes:
                    print("\nНет сохраненных заметок.")
                else:
                    print("\nСписок заметок:")
                    for i, note in enumerate(notes, 1):
                        print(f"{i}. {note[:-4]}")
                    
                    note_choice = input("\nВведите номер заметки для удаления (или 0 для отмены): ")
                    if note_choice != "0":
                        try:
                            note_idx = int(note_choice) - 1
                            if 0 <= note_idx < len(notes):
                                os.remove(os.path.join(NOTES_DIR, notes[note_idx]))
                                self.log("NOTEPAD", f"Удалена заметка: {notes[note_idx]}")
                                print("\nЗаметка удалена!")
                                sleep(1)
                            else:
                                print("\nНеверный номер заметки.")
                        except ValueError:
                            print("\nНеверный ввод.")
                
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "0":
                return
    
    def browser(self):
        """Браузер"""
        while True:
            self.clear_screen()
            print("\n--- Браузер Ru.bin ---")
            print("1. Открыть сайт Ru.bin")
            print("2. Открыть другой сайт")
            print("0. Назад")
            
            choice = input("\nВыберите действие: ")
            
            if choice == "1":
                print("\nОткрываю сайт Ru.bin...")
                webbrowser.open("http://z9081972.beget.tech/")
                self.log("BROWSER", "Открыт сайт Ru.bin")
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "2":
                url = input("\nВведите URL (например, example.com): ")
                if not url.startswith(('http://', 'https://')):
                    url = 'http://' + url
                
                print(f"\nОткрываю {url}...")
                try:
                    webbrowser.open(url)
                    self.log("BROWSER", f"Открыт сайт: {url}")
                except Exception as e:
                    print(f"\nОшибка: {e}")
                    self.log("BROWSER", f"Ошибка открытия сайта: {url} - {str(e)}")
                
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "0":
                return
    
    def calculator(self):
        """Калькулятор"""
        self.clear_screen()
        print("\n--- Калькулятор ---")
        print("Введите математическое выражение (например, 2+2)")
        print("Или 'выход' для возврата")
        
        while True:
            expr = input("\n> ").strip().lower()
            
            if expr == 'выход':
                self.log("CALC", "Закрытие калькулятора")
                return
            
            try:
                # Безопасное вычисление выражения
                if any(c in expr for c in "'\"\\"):
                    raise ValueError("Недопустимые символы")
                
                result = eval(expr, {'__builtins__': None}, {})
                print(f"Результат: {result}")
                self.log("CALC", f"Вычисление: {expr} = {result}")
            except Exception as e:
                print(f"Ошибка: {e}")
                self.log("CALC", f"Ошибка вычисления: {expr} - {str(e)}")
    
    def settings_menu(self):
        """Меню настроек"""
        while True:
            self.clear_screen()
            print("\n--- Настройки ---")
            print(f"1. Имя компьютера: {self.settings['pc_name']}")
            print(f"2. Рабочая группа: {self.settings['workgroup']}")
            print(f"3. Автоочистка экрана: {'Вкл' if self.settings['autoclear'] else 'Выкл'}")
            print(f"4. Логирование действий: {'Вкл' if self.settings['log_actions'] else 'Выкл'}")
            print("5. Пользователи")
            print("6. Лицензия")
            print("7. Сохранить и выйти")
            print("0. Выйти без сохранения")
            
            choice = input("\nВыберите настройку для изменения: ")
            
            if choice == "1":
                new_pc_name = input("\nВведите новое имя компьютера: ")
                self.settings["pc_name"] = new_pc_name
                self.log("SETTINGS", f"Изменено имя компьютера на: {new_pc_name}")
                print("\nИмя компьютера изменено.")
                sleep(1)
            
            elif choice == "2":
                new_workgroup = input("\nВведите новую рабочую группу: ")
                self.settings["workgroup"] = new_workgroup
                self.log("SETTINGS", f"Изменена рабочая группа на: {new_workgroup}")
                print("\nРабочая группа изменена.")
                sleep(1)
            
            elif choice == "3":
                self.settings["autoclear"] = not self.settings["autoclear"]
                state = "Вкл" if self.settings["autoclear"] else "Выкл"
                self.log("SETTINGS", f"Автоочистка экрана: {state}")
                print(f"\nАвтоочистка экрана: {state}")
                sleep(1)
            
            elif choice == "4":
                self.settings["log_actions"] = not self.settings["log_actions"]
                state = "Вкл" if self.settings["log_actions"] else "Выкл"
                self.log("SETTINGS", f"Логирование действий: {state}")
                print(f"\nЛогирование действий: {state}")
                sleep(1)
            
            elif choice == "5":
                self.user_management()
            
            elif choice == "6":
                self.license_settings()
            
            elif choice == "7":
                self.save_data("settings")
                self.log("SETTINGS", "Сохранение настроек")
                print("\nНастройки сохранены!")
                sleep(1)
                return
            
            elif choice == "0":
                self.load_data()  # Загружаем сохраненные настройки, отменяя изменения
                return
    
    def user_management(self):
        """Управление пользователями"""
        while True:
            self.clear_screen()
            print("\n--- Управление пользователями ---")
            print("1. Добавить пользователя")
            print("2. Удалить пользователя")
            print("3. Изменить пароль")
            print("0. Назад")
            
            choice = input("\nВыберите действие: ")
            
            if choice == "1":
                username = input("\nВведите имя нового пользователя: ")
                password = input("Введите пароль: ")
                
                self.users_data["users"].append({
                    "username": username,
                    "password": password,
                    "role": "user"
                })
                
                self.save_data("users")
                self.log("USER", f"Добавлен пользователь: {username}")
                print("\nПользователь добавлен!")
                sleep(1)
            
            elif choice == "2":
                print("\nСписок пользователей:")
                for i, user in enumerate(self.users_data["users"], 1):
                    print(f"{i}. {user['username']} ({user['role']})")
                
                user_choice = input("\nВыберите пользователя для удаления (или 0 для отмены): ")
                if user_choice != "0":
                    try:
                        user_idx = int(user_choice) - 1
                        if 0 <= user_idx < len(self.users_data["users"]):
                            if self.users_data["users"][user_idx]["role"] == "admin":
                                print("\nНельзя удалить администратора!")
                            else:
                                username = self.users_data["users"][user_idx]["username"]
                                del self.users_data["users"][user_idx]
                                self.save_data("users")
                                self.log("USER", f"Удален пользователь: {username}")
                                print("\nПользователь удален!")
                        else:
                            print("\nНеверный номер пользователя.")
                    except ValueError:
                        print("\nНеверный ввод.")
                
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "3":
                print("\nСписок пользователей:")
                for i, user in enumerate(self.users_data["users"], 1):
                    print(f"{i}. {user['username']} ({user['role']})")
                
                user_choice = input("\nВыберите пользователя для смены пароля (или 0 для отмены): ")
                if user_choice != "0":
                    try:
                        user_idx = int(user_choice) - 1
                        if 0 <= user_idx < len(self.users_data["users"]):
                            new_password = input("\nВведите новый пароль: ")
                            self.users_data["users"][user_idx]["password"] = new_password
                            self.save_data("users")
                            self.log("USER", f"Изменен пароль для: {self.users_data['users'][user_idx]['username']}")
                            print("\nПароль изменен!")
                        else:
                            print("\nНеверный номер пользователя.")
                    except ValueError:
                        print("\nНеверный ввод.")
                
                input("\nНажмите Enter для продолжения...")
            
            elif choice == "0":
                return
    
    def license_settings(self):
        """Настройки лицензии"""
        self.clear_screen()
        print("\n--- Настройки лицензии ---")
        print(f"Текущая лицензия: {'Активирована' if self.license_data['active_license'] else 'Не активирована'}")
        
        if self.license_data["active_license"]:
            print(f"Лицензионный ключ: {self.license_data['license_key']}")
            print(f"Тип лицензии: {self.license_name}")
            print(f"Дата активации: {self.license_data['activation_date']}")
            
            if self.license_expiry:
                print(f"Срок действия: {self.license_expiry}")
        
        print("\n1. Активировать лицензию")
        print("2. Проверить лицензию")
        print("0. Назад")
        
        choice = input("\nВыберите действие: ")
        
        if choice == "1":
            self.activate_license_screen()
        elif choice == "2":
            if self.check_license():
                print("\nЛицензия действительна.")
                print(f"Тип: {self.license_name}")
                
                if self.license_expiry:
                    print(f"Срок действия: {self.license_expiry}")
            else:
                print("\nЛицензия недействительна или срок ее действия истек.")
            
            input("\nНажмите Enter для продолжения...")
        elif choice == "0":
            return
    
    def system_info(self):
        """Сведения о системе"""
        self.clear_screen()
        print("\n--- Сведения о системе ---")
        print(f"Ru.bin OS {VERSION}")
        print(f"Имя компьютера: {self.settings['pc_name']}")
        print(f"Рабочая группа: {self.settings['workgroup']}")
        print(f"Текущий пользователь: {self.current_user}")
        
        if self.license_data["active_license"]:
            print(f"\nЛицензия: Активирована")
            print(f"Лицензионный ключ: {self.license_data['license_key']}")
            print(f"Тип лицензии: {self.license_name}")
            
            if self.license_expiry:
                print(f"Срок действия: {self.license_expiry}")
        else:
            print("\nЛицензия: Не активирована")
        
        print("\nДля обновления системы посетите сайт Ru.bin")
        print("http://z9081972.beget.tech/")
        
        self.log("SYSTEM", "Просмотр сведений о системе")
        input("\nНажмите Enter для возврата...")
    
    def command_line(self):
        """Командная строка"""
        self.clear_screen()
        print("\n--- Командная строка Ru.bin ---")
        print("Введите 'помощь' для списка команд")
        
        while True:
            cmd = input("\nC:\\> ").lower()
            
            if cmd == "выход":
                self.log("CMD", "Закрытие командной строки")
                break
            
            elif cmd == "помощь":
                print("\nДоступные команды:")
                print("дир - показать содержимое текущей директории")
                print("создать_папку <имя> - создать новую папку")
                print("удалить <имя> - удалить файл или папку")
                print("crash - имитация сбоя системы")
                print("очистить - очистить экран")
                print("выход - выйти из командной строки")
            
            elif cmd.startswith("дир"):
                print("\nСодержимое текущей директории:")
                for item in os.listdir('.'):
                    print(item)
                
                self.log("CMD", "Выполнена команда: dir")
            
            elif cmd.startswith("создать_папку"):
                folder_name = cmd[13:].strip()
                if folder_name:
                    try:
                        os.makedirs(folder_name)
                        print(f"\nПапка '{folder_name}' создана.")
                        self.log("CMD", f"Создана папка: {folder_name}")
                    except Exception as e:
                        print(f"\nОшибка: {e}")
                        self.log("CMD", f"Ошибка создания папки: {folder_name} - {str(e)}")
                else:
                    print("\nУкажите имя папки.")
            
            elif cmd.startswith("удалить"):
                target = cmd[7:].strip()
                if target:
                    try:
                        if os.path.isdir(target):
                            os.rmdir(target)
                            print(f"\nПапка '{target}' удалена.")
                            self.log("CMD", f"Удалена папка: {target}")
                        else:
                            os.remove(target)
                            print(f"\nФайл '{target}' удален.")
                            self.log("CMD", f"Удален файл: {target}")
                    except Exception as e:
                        print(f"\nОшибка: {e}")
                        self.log("CMD", f"Ошибка удаления: {target} - {str(e)}")
                else:
                    print("\nУкажите имя файла или папки.")
            
            elif cmd == "crash":
                self.log("SYSTEM", "Имитация сбоя системы")
                self.blue_screen()
                break
            
            elif cmd == "очистить":
                self.clear_screen()
                print("\n--- Командная строка Ru.bin ---")
                print("Введите 'помощь' для списка команд")
            
            else:
                print(f"\nНеизвестная команда: '{cmd}'")
                self.log("CMD", f"Неизвестная команда: {cmd}")
    
    def blue_screen(self):
        """Синий экран смерти"""
        self.clear_screen()
        print("\n\n*** STOP: 0x0000007B (0xFFFFF880009A9928, 0xFFFFFFFFC0000034, 0x0000000000000000, 0x0000000000000000)")
        print("CRASH_DLL_32 - Ошибка загрузки критического компонента системы")
        print("\nСистема будет перезагружена через 10 секунд...")
        sleep(10)
        print("\nПерезагрузка...")
        sleep(2)
        self.show_startup_animation()
        self.log("SYSTEM", "Перезагрузка системы после сбоя")
    
    def games_menu(self):
        """Меню игр"""
        while True:
            self.clear_screen()
            print("\n--- Игры ---")
            print("1. Угадай число")
            print("2. Камень-ножницы-бумага")
            print("0. Назад")
            
            choice = input("\nВыберите игру: ")
            
            if choice == "1":
                self.guess_number_game()
            elif choice == "2":
                self.rock_paper_scissors()
            elif choice == "0":
                return
    
    def guess_number_game(self):
        """Игра 'Угадай число'"""
        self.clear_screen()
        print("\n--- Угадай число ---")
        print("Я загадал число от 1 до 100. Попробуй угадать!")
        
        number = random.randint(1, 100)
        attempts = 0
        self.log("GAME", "Запуск игры 'Угадай число'")
        
        while True:
            guess = input("\nТвой вариант (или 'выход' для выхода): ")
            
            if guess.lower() == "выход":
                print(f"\nЗагаданное число было: {number}")
                self.log("GAME", f"Выход из игры 'Угадай число'. Число было: {number}")
                input("\nНажмите Enter для возврата...")
                return
                
            try:
                guess_num = int(guess)
                attempts += 1
                
                if guess_num < number:
                    print("\nСлишком мало!")
                elif guess_num > number:
                    print("\nСлишком много!")
                else:
                    print(f"\nПоздравляю! Ты угадал число за {attempts} попыток!")
                    self.log("GAME", f"Угадано число {number} за {attempts} попыток")
                    input("\nНажмите Enter для возврата...")
                    return
            except ValueError:
                print("\nПожалуйста, введите число или 'выход'.")
    
    def rock_paper_scissors(self):
        """Игра 'Камень-ножницы-бумага'"""
        self.clear_screen()
        print("\n--- Камень-ножницы-бумага ---")
        choices = ['камень', 'ножницы', 'бумага']
        self.log("GAME", "Запуск игры 'Камень-ножницы-бумага'")
        
        while True:
            print("\nВыбери: камень, ножницы, бумага или выход")
            player_choice = input("Твой выбор: ").lower()
            
            if player_choice == "выход":
                self.log("GAME", "Выход из игры 'Камень-ножницы-бумага'")
                return
                
            if player_choice not in choices:
                print("\nНеверный выбор. Попробуй еще раз.")
                continue
                
            computer_choice = random.choice(choices)
            print(f"\nКомпьютер выбрал: {computer_choice}")
            
            if player_choice == computer_choice:
                print("\nНичья!")
                self.log("GAME", f"Ничья: {player_choice} vs {computer_choice}")
            elif (player_choice == "камень" and computer_choice == "ножницы") or \
                 (player_choice == "ножницы" and computer_choice == "бумага") or \
                 (player_choice == "бумага" and computer_choice == "камень"):
                print("\nТы победил!")
                self.log("GAME", f"Победа: {player_choice} vs {computer_choice}")
            else:
                print("\nКомпьютер победил!")
                self.log("GAME", f"Поражение: {player_choice} vs {computer_choice}")
            
            input("\nНажмите Enter для продолжения...")
            self.clear_screen()
            print("\n--- Камень-ножницы-бумага ---")
    
    def run(self):
        """Основной цикл системы"""
        self.show_startup_animation()
        
        # Проверка лицензии при запуске
        if not self.check_license():
            print("\nЛицензия не активирована или срок ее действия истек.")
            self.activate_license_screen()
            if not self.running:
                return
        
        # Вход в систему
        while self.running and not self.current_user:
            if not self.login():
                retry = input("\nПопробовать снова? (да/нет): ").lower()
                if retry != "да":
                    self.running = False
        
        # Основной цикл системы
        while self.running:
            try:
                # Периодическая проверка лицензии
                if not self.check_license():
                    print("\nВнимание! Срок действия вашей лицензии истек!")
                    print("Пожалуйста, приобретите новую лицензию на сайте Ru.bin")
                    print("http://z9081972.beget.tech/")
                    input("\nНажмите Enter для продолжения...")
                
                if self.current_screen == "desktop":
                    self.desktop()
                elif self.current_screen == "start_menu":
                    self.start_menu()
            
            except KeyboardInterrupt:
                print("\nДля выхода из системы используйте меню.")
                sleep(1)
            
            except Exception as e:
                print(f"\nКритическая ошибка: {e}")
                self.log("ERROR", f"Критическая ошибка: {str(e)}")
                sleep(3)
                self.running = False

if __name__ == "__main__":
    os.system('cls' if os.name == 'nt' else 'clear')
    os.system('title Ru.bin OS 1.1 beta' if os.name == 'nt' else '')
    
    rubin_os = RubinOS()
    rubin_os.run()
    
    print("\nСпасибо за использование Ru.bin OS!")